clc, clear

%% PARTE INIZIALE

% Posizionamento sulla Directory principale
fileRef = 'myTdmsReader.m';
mainDir = replace(which(fileRef),fileRef,'');
cd(mainDir)

% Richiamo alle librerie di funzione
LibI = myInterfacciaDAQ;
LibO = myOutputFile;
LibS = mySignalMaker;
LibT = myTdmsReader;
% pathZero = 'C:\Users\nitro\Desktop\old tesi\I Miei Progressi\results Daq\Loa\zero60 _Loa (Nov 15 12_26).txt';
% Zero = LibO.extractFromFile(pathZero);
% Zero = mean(Zero(:,[1 4]));  %--> [2.872748438	-10.39129517 -0.001207838	-0.088105225]
Zero = [2.872748438 -0.088105225];

% Connessione ai dispositivi hardware
global dq dg dm
realConn = 1;
[dq,dm,dg] = LibI.connect2DAQ(realConn,false);
disp('I''m ready');
N = length(dg.Channels);

dg.write([[5.5 5.5 5.5]; [5.5 5.5 5.5]])
%% CREAZIONE INTERFACCIA (Figure)
close all
global PL ax info link history
[F,ax,PL,info]=LibI.creaInterfaccia();

[PL.Mic, updRear, setCaxis]=LibI.preparaRear(ax{4});
[PL.SurfM,    updRear.surf]=LibI.addSurf(PL.Mic.XData, PL.Mic.YData, 100);

updRear.col( 1:16 ) %aggiorno i colori dello scatter
updRear.siz( 1:16 ) %aggiorno le size dello scatter

%% Configurazione Pre-Simulazione
global parentFolder

tempo  = 50; %50; %15; %durata complessiva  
del    = 25; %3; %25; %delay
parentFolder = "results RETRY"; %<-- Nome della cartella della sessione di tests.
enableChan   = [1 1 1];   %<-(1:on/0:off) per [LoadCell, Microphones, Getti]
channelRate  = 4000;      %<-Frequenza di comunicazione con i getti =dg.Rate
dq.Rate = 2e3;         % <-RateLimit: [1.6129e+03 50000]
dm.Rate = dq.Rate;     % <-RateLimit: [0.1000 2.3529e+05]
dg.Rate = channelRate; % <-RateLimit: [0.1000 100000]
dq.ScansAvailableFcnCount = round(dq.Rate/10);
dm.ScansAvailableFcnCount = round(dm.Rate/10);

% Creazione delle directory per il posizionamento dei files
userChoice = 1; % % <<[true/false]
subFolders = ["Loa" "Mic" "Get" "Note"];
LibO.SetUpFolders(mainDir, parentFolder, subFolders);

%% Bozza di segnale:

scelta = 2;
fcn = cell(1,3);
switch scelta
    case 0
        % scrivi il segnale che desideri:
         fcn{1} = @(t) 5.5; % TOP
         fcn{2} = @(t) 5.5; % BOT
         fcn{3} = @(t) 5.5; % SIDE

    case 1 %Agu
         scalino = @(x,y,t) interp1(x,5.5+4*y,t,'linear');
         fcn{1} = @(t) 5.5; %8.59516; %6.83939; %7.58759; %7.98236; %
         fcn{2} = @(t) 5.5; %9.34958; %6.71572; %9.30358; %9.28252; %scalino([0 10 80],[0 0 1],t);
         fcn{3} = @(t) scalino([0 2 4],[0 1 1],t); %9.48311; %8.80587; %9.29427; %9.36486; %scalino([0 10 80],[0 0 1],t);

%          fcn{1} = @(t) scalino([0  9 10 20 30],[0 1 0 0 0],t);
%          fcn{2} = @(t) scalino([0 10 19 20 30],[0 0 1 0 0],t);
%          fcn{3} = @(t) scalino([0 10 20 29 30],[0 0 0 1 0],t);
         
    case -1 %GA champions
        seno = @(time,a,b,c) feval( LibS.DominikFcn(a,b,c), time-pi/2 );
%         fcn{1} = @(t) seno(t,7.61,7.13,26.11); %<- GA (100) 300% n800
%         fcn{2} = @(t) seno(t,7.13,8.72,31.4);
%         fcn{3} = @(t) seno(t,8.44,8.88,17.72); 

%         fcn{1} = @(t) seno(t,6.16,6.69,13.70); %<- GA (9) 300% n600
%         fcn{2} = @(t) seno(t,6.79,6.63,21.22);
%         fcn{3} = @(t) seno(t,8.01,7.88,16.70); 
        
%         fcn{1} = @(t) seno(t,5.89,5.71,2.86); %<- GA (8) 25% n800
%         fcn{2} = @(t) seno(t,6.18,7.32,12.47);
%         fcn{3} = @(t) seno(t,6.26,6.74,8.62);        
        
%         fcn{1} = @(t) seno(t,8.24,6.16,38.28); %<- GA (7) 25% n600
%         fcn{2} = @(t) seno(t,8.39,8.94,44.47);
%         fcn{3} = @(t) seno(t,9.12,9.27,39.09);
        
%         fcn{1} = @(t) seno(t,[6.7148  3.0135],[1.8032 8.1356],[41.9444 36.4217]);  %<- GA (57) -50% n600 
%         fcn{2} = @(t) seno(t,[3.6876 3.5147],[8.5777  9.2576],[6.3050 6.2924]);
%         fcn{3} = @(t) seno(t,[8.8797 6.2414],[8.9936 2.4634],[18.8287 44.2256]);

%         fcn{1} = @(t) seno(t,[5.4257  8.3374],[ 7.2570  1.3163],[ 3.7361 24.0938]);  %<- GA (59) -50% n800 
%         fcn{2} = @(t) seno(t,[5.6528 5.5031],[3.5836  4.7801],[8.7966 15.1867]);
%         fcn{3} = @(t) seno(t,[7.2212 7.7045],[9.3670 2.6015],[43.2447 45.7392]);

%         fcn{1} = @(t) seno(t,9.4536,7.2797,40.7570); %<- GA (67) -50% n600
%         fcn{2} = @(t) seno(t,8.4830,8.9038,3.7598);
%         fcn{3} = @(t) seno(t, 9.4662,5.7217,34.3253);

%         fcn{1} = @(t) seno(t,8.2978,5.7438,8.1353); %<- GA (69) -50% n800
%         fcn{2} = @(t) seno(t,5.5139,8.0332,36.0351);
%         fcn{3} = @(t) seno(t,8.1412,9.4503,8.5936);

%         fcn{1} = @(t) seno(t,8.3896,7.4403,7.4296); %<- GA (77) 50% n600
%         fcn{2} = @(t) seno(t,8.8398,8.9866,1.0494);
%         fcn{3} = @(t) seno(t,9.2514,8.1462,21.4285);

%         fcn{1} = @(t) seno(t,8.1049,5.8532,11.4941); %<- GA (79) 50% n800
%         fcn{2} = @(t) seno(t,7.5202,7.7501,33.4257);
%         fcn{3} = @(t) seno(t,8.2281,9.2737,37.1347);
        
%         fcn{1} = @(t) 6.8394; %<- GA (49) -50% n800
%         fcn{2} = @(t) 6.7157;
%         fcn{3} = @(t) 8.8054;

%         fcn{1} = @(t) 7.5853; %<- GA (39) 50% n800
%         fcn{2} = @(t) 9.2939;
%         fcn{3} = @(t) 9.2868;

%         fcn{1} = @(t) seno(t,[0.5946  6.3371],[4.7271  5.9543],[4.8344 1.3505]);  %<- GA (87) 50% n600 
%         fcn{2} = @(t) seno(t,[0.7576 8.4364],[1.1378  8.0718],[7.6872 15.3690]);
%         fcn{3} = @(t) seno(t,[5.5380 5.7878],[3.8681 5.2945],[20.5415 18.5573]);

%         fcn{1} = @(t) seno(t,[3.7912  4.0437],[5.3421  1.4048],[24.2439 13.5556]);  %<- GA (89) 50% n800 
%         fcn{2} = @(t) seno(t,[5.7080 8.1180],[3.7689  8.0691],[10.3121 17.7983]);
%         fcn{3} = @(t) seno(t,[4.5489 6.8861],[4.5948 6.4643],[16.0272 4.6513]);
        
    case 2 %Domenico
        seno = @(time,a,b,c) feval( LibS.DominikFcn(a,b,c), time-pi/2 );

%         % Sincrono
%         fcn{1} = @(t) 9.3577; fcn{2} = fcn{1}; fcn{3} = fcn{1};
        
%         % Asincrono
%         fcn{1} = @(t) 7.0232; fcn{2} = @(t) 7.3173; fcn{3}=@(t) 9.008;
          
%         % 20 individui n900 single
%           fcn{1} = @(t) seno(t, [5.3049 4.9938],[3.9925 3.8604], [12.262 13.62]);
%           fcn{2} = fcn{1}; fcn{3} = fcn{1};
          
%         % 30 individui n900 single
%           fcn{1} = @(t) seno(t, [5.875 5.3491],[3.4286 3.2132], [28.266 5.172]);
%           fcn{2} = fcn{1}; fcn{3} = fcn{1};
          
%        % 50 individui n900 single
%           fcn{1} = @(t) seno(t, [5.6243 5.2088],[3.8054 3.4278], [19.781 12.43]);
%           fcn{2} = fcn{1}; fcn{3} = fcn{1};
                  
    case 3 %Enrico
        
%         %casoA (n = 600)
%         seno = @(time,a,b,c) feval( LibS.DominikFcn(a,b,c), time-pi/2 );
%         fcn{1} = @(t) seno(t,8.5 ,5.5,14.8 );
%         fcn{2} = @(t) seno(t,8.74,5.5,42.17);
%         fcn{3} = @(t) seno(t,9.83,5.5,48.81);


%         %casoB (n = 800)
%         seno = @(time,a,b,c) feval( LibS.DominikFcn(a,b,c), time-pi/2 );
%         fcn{1} = @(t) seno(t, 5.63,5.5,24.48);
%         fcn{2} = @(t) seno(t, 7.52,5.5, 7.56);
%         fcn{3} = @(t) seno(t, 8.63,5.5,47.52);

end

inp.userfcn = fcn;

%%
inp.CLoop = 'manual';                          % % <<['GA' 'manual']


    PopSize = 25;
    MaxGen  = 10 -1;
    
% passaggio di consegna dei parametri costanti e non:
% inp.channelRate = channelRate, inp.userChoice = userChoice, etc. etc
for h=["channelRate" "userChoice" "subFolders" "parentFolder",...
        "enableChan" "mainDir" "tempo" "del" "updRear" "Zero"]
    inp.(h) = eval(h);    
      
end

if strcmpi(inp.CLoop,'GA') %sono in (GA) MODE
    
    inp.sigMode = 'multisin';
    sigtipi = ["manual" "sin" "basedSin" "randomP" "multiSin" "open"];
    inp.sigMode = validatestring(inp.sigMode, sigtipi);

    convenz.classes = categorical(["Voltage" "frequency" "parameter",...
                       "period" "unity" "vPoint" "Voltage"]);
    convenz.letter1 = ["V" "f" "x" "P" "u" "Vp" "Vm"];
    convenz.lb      = [5.5 0.01 -inf 0.02 0 5.5 0];
    convenz.ub      = [9.5 30    inf 100  1 9.5 9.5];  %Fmax 50 tranne per GA87
    
    switch inp.sigMode
        case 'sin'   
         % per ogni channel mi serve: 1Vmax, 1Vmin, 1freq
         qua = repmat( {[1 1 1]} ,1,3); %[1 input, 1 input, 1input ] x 3
         cID = repmat( [1,1,2] ,1,3);   %[1° 1° 2°] -> [V V f] x 3
         
         seno = @(time,a,b,c) feval( LibS.DominikFcn(a,b,c), time-pi/2 );
         fcn = @(time,VM,Vm,f) seno(time,VM,Vm,f);
         fcn = repmat( {fcn}, 1,3);

        case 'randomP'
         qua = repmat( {[5 1]} ,1,3); %[5 random point, 1 Period] x 3
         cID = repmat(  [6 4]  ,1,3); %[6°x5, 4°x1]->[VoltagePoint, Period] x 3
         
         curve = @(pts, p) LibS.periodSpline( pts, p, 'mode','as_is');
         fcn = @(time,points,period) feval( curve(points, period) ,time);
         fcn = repmat( {fcn}, 1,3);
        case 'basedSin'
            
        case 'multiSin'
         qua = repmat( {[2 2 2]} ,1,3); %[2 input, 2 input, 2input ] x 3
         cID = repmat( [7,7,2] ,1,3);   %[1°x2, 1°x2, 2°x2] -> [Vm Vm f] x 3
         
         seno = @(time,a,b,c) feval( LibS.DominikFcn(a,b,c), time-pi/2 );
         fcn = @(time,VM,Vm,f) seno(time,VM,Vm,f);
         fcn = repmat( {fcn}, 1,3);
         
        case 'open'
         qua = repmat( {1}, 1,3);  %[1 input ] x 3
         cID = repmat( (1), 1,3);  %[V] x 3
        
         fcn = @(time, V) V;
         fcn = repmat( {fcn}, 1,3);

        otherwise
         disp('I cannot understand which GA optimization test you want')   

    end

    convenz.paramfcns = fcn;
    convenz.quantity  = qua;
    convenz.classID   = cID;
    vv = repelem( convenz.classID, [convenz.quantity{:}]);
    lb = convenz.lb( vv );
    ub = convenz.ub( vv );
    
    inp.convenz = convenz;
    targetFcn = @(X) tryGenericForcing(X,inp);
    
    nomeHistory = "history"+strrep(parentFolder,"results ","")+".mat";
    continues = false;
    if isfile(nomeHistory)
     disp("Identificata History preesistente!")
     load(nomeHistory); continues = true;
     if length(history)>1 && isequal(history(end).pop,history(end-1).pop)
        history(end) = []; 
     end
    else
     history = []; 
    end
    
    % (1) CROSSOVER: 'CrossoverFcn',(@crossoverheuristic|@crossoverintermediate)
    % (2) MUTATION: 'MutationFcn',@mutationadaptfeasible <- obbligatorio
    % (3) MIGRATION: non serve, perché ga(..) non sfrutta il parallel working
    options = optimoptions(@ga,'MutationFcn',@mutationadaptfeasible,...
                        'CrossoverFcn',@crossoverheuristic);
    options = optimoptions(options,'PlotFcn',{@gaplotbestf}, ...
                        'PopulationSize', PopSize, 'SelectionFcn','selectionroulette',...
                        'MaxGenerations', MaxGen, 'OutputFcn', @gaoutfun);
    if continues
       options = optimoptions(options, 'InitialPopulationMatrix',...
                        history(end).pop, 'InitialScoresMatrix',history(end).score);
    end
else  %sono in (MANUAL) MODE
    inp.sigMode = '';
end

% collego la visuale dei plot dei getti con la built-in di matlab 'linkprop'
link=linkprop([ax{1:3}],'XLim');

if strcmp(inp.CLoop,'GA') 

    %GA MODE: lancio il processo di ottimizzazione.
    [sol, fval, exfl, outp, pop, scores] = ga(@(X) targetFcn(X),length(lb),[],[],[],[],...
                       lb,ub,[],[],options); 
else

    %MANUAL MODE: lancio la singola simulazione.
    [dcd,out] = MakeOneSim(inp);

end

fclose('all'); %chiudo tutti i files eventualmente aperti da MATLAB.

if strcmp(inp.CLoop,'GA')

    % se ero in GA MODE, salvo la convenzione nel file di GA History
    convenz.LB = lb;
    convenz.UB = ub;
    history(1).cc = convenz;
    save("history"+strjoin(round(datevec(now))+"",'_')+".mat" ,'history');
end

%% recap del GA
if strcmp(inp.CLoop,'GA')
    ax{6} = LibO.GArecap(history,{3:3:9},0);
end

%%


%% funzioni ausiliaries

function [finalValue,out] = tryGenericForcing( params, allVariables)
allVariables.CLoop = 'GA';
allVariables.userChoice = false;
allVariables.convenz.X = params;
[finalValue, out] = MakeOneSim(allVariables);
end

function spezzaStruct(inp)
    for h=string(fieldnames(inp)')
    assignin('caller', h, inp.(h))
    %crea ogni variabile con il generico nome <'h'> ed il valore di s.<'h'>
    %ognuna di queste variabili è riutilizzabile solo dalla function che
    %richiama 'spezzaStruct(..)', cioè 'MakeOneSim(..)' in fondo alla pagina.
    end
end

function newFcn = applyParams( convenz )
    % convenz è caratterizzata da queste properties:
    % convenz.quantity = {[],[],[]} un cell array con 3 diversi vettori
    %                   la rispettiva somma del vettore i-esimo indica il
    %                   totale di parametri X allocati per il canale
    %                   i-esimo.
    % convenz.fcn = {@(time,a,b,c} something(time,a,b,c), ...} x3
    %                 ^ un cell array 1x3, con al loro interno un function handle 
    %                   che prende per primo in ingresso un parametro implicito 
    %                   'time' che rimarrà anonimo, e poi tutti gli altri
    %                   parametri 'a,b,c'<< in cui verranno immessi i valori 
    %                   di convenz.X opportunamente riorganizzati.
    % convenz.X   = [1 x "tot"] parametric variables
    
    newFcn = cell(1,3);
    inputsPerChan = cellfun( @sum, convenz.quantity); %conto la somma totale di inputs per ogni diverso channel
    Xchann = mat2cell( convenz.X, 1, inputsPerChan); %smembro il vettore X in 3 blocchi con le rispettive somme
    
    for i=1:3 %[top bot side]
        
        %all'interno dello stesso channel, spezzo il blocco secondo la
        %suddivisione stabilita da quantity{i}
        Xcell = mat2cell(Xchann{i}, 1, convenz.quantity{i});
        
        %Applico il set ['time','Xcell'] come input al function handle i-esimo. 
        newFcn{i} = @(time) convenz.paramfcns{i}( time,Xcell{:} );
    end
end

function s = applyTime( newFcn, channelRate, tempo, del )
% Se il delay specificato è uno scalare, viene 
% duplicato per tutti e 3 i canali.
if numel(del)<3
   del = repmat(del,1,3); 
end

% Ora che in input è fornito un cell contenente 3 function-handle con unico
% input il Tempo, e altri parametri già fissati (o da utente o da
% 'applyParams'), non resta altro che applicare il vettore temporale ad
% ogni canale, con i rispettivi, delay e channelRate.
s = cell(1,3);
LibS = mySignalMaker;
  for i=1:3
    % Ogni newFcn{i} sarebbe qualcosa del tipo:  @(time) fcn(time, params). 
    s{i} = LibS.timeFcn2VetSignal( newFcn{i}, channelRate, tempo, ...
                                 'delay', del(i),'ini',5.5, 'show',false);
  end
end

function [traccia,period]=extractPeriodicS(timeFcns, convenz, timeStep)
passo = 0.001;
if nargin>2
   passo = timeStep; 
end

L = cellfun( @sum, convenz.quantity);
M = cellfun( @length, convenz.quantity);
maxAllowedPeriod = 3;
period = zeros(1,3);
traccia = cell(1,3);
    for i= 1:3
       idx     = sum(L(1:i-1))  +(1:L(i));
       idxC    = sum(M(1:i-1))  +(1:M(i));
       x = convenz.X(idx);
       classes = repelem( convenz.classID(idxC), convenz.quantity{i} );
       
       seconds = [1./x(classes==2) x(classes==4)];
       seconds(isnan(seconds)|isinf(seconds))=[];
       if isempty(seconds)
           seconds=0.1;
       else
           seconds=min( maxAllowedPeriod, max(seconds));  
       end
       period(i) = seconds;
       
       %calcolo del segnale sul rispettivo periodo
       tt = 0:passo:period(i);
       traccia{i} = timeFcns{i}(tt);
       if numel(traccia{i})==1
           traccia{i} = repmat( traccia{i}, size(tt) );
       end
       
    end
end


function [dcd,out]=MakeOneSim(allVariables)

global ax dg dm dq

LibI = myInterfacciaDAQ;
LibO = myOutputFile;
LibS = mySignalMaker;

%(!) ora non serve più specificare 'inp.' davanti alla variabile che vuoi
% utilizzare, grazie a 'spezzaStruct(..)'
spezzaStruct(allVariables); 
%>> potrai utilizzare 'fcn', 'del', 'tempo', 'channelRate' e tutti gli altri.

%(-2) Applicazione dei parametri
if strcmpi(CLoop,'GA')
    %(a) Se sono in modalità automatizzata usando un GA devo prima effettuare l'applicazione 
    % dei parametri X alle functions @(time,X(a:b)) fcn(time,X(a),X(b),X(c))
    timeFcns = applyParams( convenz );
    
    % Posso anche estrarre la loro componente periodica (che userò nel file di BackUp xml).
    [traccia,~]=extractPeriodicS(timeFcns, convenz);
else
    %(b) Se la modalità è manuale, allora l'utente ha già provveduto a fornire
    %un cell di function-handles esclusivamente tempo-dipendenti.
    timeFcns = userfcn;
end

% (-1) Applicazione della linea temporale
% Ora devo solamente applicare la linea temporale al segnale, che ha tutti
% gli altri parametri definiti, ricordandomi di estendere il segnale ad
% almeno una durata 'tempo' e applicando il forcing dopo un certo
% intervallo 'del' (delay).
s = applyTime( timeFcns, channelRate, tempo, del );

% (0) Mi assicuro che il segnale non sia difettoso
[~,S]=LibS.isLengthOk(s, 'close');   %<< inserisce un '5.4 Volts' alla fine
[~,S]=LibS.isVoltageOk(S,'correct',true); %<< corregge tutte le tensioni fuori dal Range

% (1) disegno il segnale
LibI.plotJet( ax(1:3), S, channelRate);

% (2) chiudo eventuali vecchi file
fclose('all');

% (3) assegno il nome alla simulazione. Se sono in closed loop ->
% switch(false), quindi l'utente non può scegliere il formato file, sarà automatico.
switch userChoice
    case true
        [baseName,channelValid] = LibO.setFileName( '',subFolders,enableChan,dq,dm,dg);
    case false
        [baseName,channelValid] = LibO.setFileName(mainDir,subFolders,enableChan,dq,dm,dg);
end

% (4) creo i file (vuoti) per la simulazione. Conterranno le misure del
% segnale. Il baseName contiene i titoli dei file, mentre fileDest i puntatori ai file.
fileDest=LibO.creaFileTxt(channelValid, baseName);

% (5) resetto l'interfaccia e imposto la visuale più consona
LibI.resetPlots(tempo, channelValid)
linkprop([ax{1:3}],'XLim');

% (6) spiego a matlab che man mano che acquisisce il segnale, lo deve:
%  -    plottare sull'interfaccia
%  -    scrivere sui file che ho generato al punto (4)
for i=1:3
    if channelValid(i)
        switch i
            case 1
                %creazione ed assegnazione della function di plotting LC
                plotFcn = @(time, dQsig) LibI.updLC(time, dQsig); 
                fcnA = @(src,evt) LibI.writeOnFile( src, evt, fileDest.LC, plotFcn);
                dq.ScansAvailableFcn = fcnA;
                
            case 2
               %creazione function di plotting MIC
                plotFcn = @(time, dMsig) LibI.updMI(dMsig, false, []);  % 3° input: puoi mettere a) [] >> non aggiorna niente, 
                                                                                               % b) updRear.surf >> aggiorna la surface.
                fcnB = @(src,evt) LibI.writeOnFile( src, evt, fileDest.MI,plotFcn);
                dm.ScansAvailableFcn = fcnB;
                
            case 3
                %carico in anticipo il segnale sul dispositivo Getti.
                dg.preload(S);
                
                %scrivo il segnale sintetizzato nel file dei Getti (visto che lo conosco tutto).
                formato = ['%f' repmat('\t%f',1,size(S,2)) '\n'];
                fprintf( fileDest.GE, formato, [(0:size(S,1)-1)'/dg.Rate S]');
        end
    end
end

% (7) lancio la simulazione e ne analizzo il segnale
aux = struct('tempo',tempo, 'fileDest',fileDest, 'baseName',baseName,...
              'newPath',mainDir+parentFolder);
          
aux.calculation = struct('delay',del,'Zero',Zero);
out = LibI.GOsym(channelValid, aux); % << QUI SI Lancia la simulazione!

try
    dcd = out.DeltaCD;
catch ME
    dcd = nan; disp('(!) qualche problema (!)')
    disp(ME)
end

% (8) salvo in backup
if strcmpi(CLoop,'GA') && channelValid(3) && ~isempty(fieldnames(out))
   LibO.send2backup(traccia, out.baseName.Get, tempo, out.m, dcd, out.CD0, out.CD);
end

end

 
function [state,options,optchanged] = gaoutfun(options,state,flag)
   global history
   optchanged = false;
   switch flag
       case 'init' 
           if ~isstruct(history)
           history = struct('pop',{state.Population},'score',state.Score,...
                  'best',min(state.Score), 'mean', mean(state.Score));
           end
       otherwise
            history(end+1).pop = state.Population;
            history(end).score = state.Score;
            history(end).best  = min(state.Score);
            history(end).mean  = mean(state.Score);
            
            if nnz( state.Score > 0 )/length(state.Score) >0.8 
             options.CrossoverFraction = rand*0.8;
             optchanged = true;
            else
             options.CrossoverFraction = 0.8+randn/30;
             optchanged = true;
            end
   end
   disp('---------')
   
end


